// Function to hide the attendance menu item
function hideAttendanceMenu() {
    // Find all menu items
    const menuItems = document.querySelectorAll('.sidebar-menu > li.treeview.parent-menu');
    
    // Loop through each menu item
    menuItems.forEach(item => {
        // Check if this item contains the clock icon used for attendance
        const icon = item.querySelector('iconify-icon[icon="solar:clock-square-broken"]');
        if (icon) {
            // Hide the entire attendance menu item
            item.style.display = 'none';
        }
    });
}

// Run on page load
document.addEventListener('DOMContentLoaded', function() {
    // Hide attendance menu immediately
    hideAttendanceMenu();
    
    // Also hide it after a short delay in case of dynamic content loading
    setTimeout(hideAttendanceMenu, 1000);
});
