<div class="main-content-wrapper">
    <?php
    if ($this->session->flashdata('exception_1')) {
        echo '<section class="alert-wrapper"><div class="alert alert-danger alert-dismissible"> 
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-hidden="true"></button>
        <div class="alert-body"><i class="icon fa fa-times me-2"></i>';
        echo $this->session->flashdata('exception_1');unset($_SESSION['exception_1']);
        //This variable could not be escaped because this is html content
        echo '</div></div></section>';
    }
    ?>
<?php
    if ($this->session->flashdata('exception')) {
        echo '<section class="alert-wrapper"><div class="alert alert-success alert-dismissible fade show"> 
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-hidden="true"></button>
        <div class="alert-body"><i class="icon fa fa-check me-2"></i>';
        echo escape_output($this->session->flashdata('exception'));unset($_SESSION['exception']);
        echo '</div></div></section>';
    }
    ?>


    <section class="content-header">
        <div class="row justify-content-between">
            <div class="col-6 p-0">
                <h3 class="top-left-header mt-2"><?php echo lang('user_profile'); ?></h3>
            </div>
            <?php $this->view('updater/breadcrumb', ['firstSection'=> lang('user_profile'), 'secondSection'=> lang('user_profile')])?>
        </div>
    </section>


    <div class="row">
        <div class="col-sm-12 col-md-12 col-lg-5 col-xl-3 mt-2">
            <div class="modern-user-profile-card">
                <div class="profile-header">
                    <div class="profile-avatar">
                        <?php 
                            $profile_photo = $this->session->userdata('photo'); 
                            if($profile_photo){
                        ?>
                            <img src="<?php echo base_url()?>uploads/employees_image/<?php echo escape_output($this->session->userdata('photo'));?>" alt="Profile Image">
                        <?php } else {?>
                            <img src="<?php echo base_url()?>uploads/site_settings/default-admin.png" alt="Profile Image">
                        <?php }?>
                        <div class="status-indicator"></div>
                    </div>
                    <div class="profile-info">
                        <h4 class="profile-name"><?php echo escape_output($this->session->userdata('full_name')); ?></h4>
                        <p class="profile-email"><?php echo escape_output($this->session->userdata('email_address')); ?></p>
                        <div class="profile-role">
                            <iconify-icon icon="solar:user-broken" width="16"></iconify-icon>
                            <span><?php echo escape_output($this->session->userdata('role_name')); ?></span>
                        </div>
                    </div>
                </div>

                <div class="profile-actions">
                    <a href="<?php echo base_url();?>User/changeProfile" class="action-item">
                        <div class="action-icon">
                            <iconify-icon icon="solar:user-check-broken" width="20"></iconify-icon>
                        </div>
                        <div class="action-content">
                            <span class="action-title"><?php echo lang('change_profile'); ?></span>
                            <span class="action-subtitle">Update your personal information</span>
                        </div>
                        <div class="action-arrow">
                            <iconify-icon icon="solar:arrow-right-broken" width="16"></iconify-icon>
                        </div>
                    </a>
                    
                    <a href="<?php echo base_url();?>User/changePassword" class="action-item">
                        <div class="action-icon">
                            <iconify-icon icon="solar:key-broken" width="20"></iconify-icon>
                        </div>
                        <div class="action-content">
                            <span class="action-title"><?php echo lang('change_password'); ?></span>
                            <span class="action-subtitle">Secure your account</span>
                        </div>
                        <div class="action-arrow">
                            <iconify-icon icon="solar:arrow-right-broken" width="16"></iconify-icon>
                        </div>
                    </a>
                    
                    <a href="<?php echo base_url();?>User/securityQuestion" class="action-item">
                        <div class="action-icon">
                            <iconify-icon icon="solar:question-circle-broken" width="20"></iconify-icon>
                        </div>
                        <div class="action-content">
                            <span class="action-title"><?php echo lang('SetSecurityQuestion'); ?></span>
                            <span class="action-subtitle">Add security questions</span>
                        </div>
                        <div class="action-arrow">
                            <iconify-icon icon="solar:arrow-right-broken" width="16"></iconify-icon>
                        </div>
                    </a>
                    
                    <a href="javascript:void(0)" class="action-item logOutTrigger">
                        <div class="action-icon logout-icon">
                            <iconify-icon icon="solar:logout-broken" width="20"></iconify-icon>
                        </div>
                        <div class="action-content">
                            <span class="action-title"><?php echo lang('logout'); ?></span>
                            <span class="action-subtitle">Sign out of your account</span>
                        </div>
                        <div class="action-arrow">
                            <iconify-icon icon="solar:arrow-right-broken" width="16"></iconify-icon>
                        </div>
                    </a>
                </div>
            </div>
        </div>
        <!-- End User Profile -->
        <div class="col-sm-12 col-md-12 col-lg-7 col-xl-9 mt-2">
            <div class="modern-table-card">
                <div class="modern-table-header">
                    <div>
                        <h2 class="modern-table-title"><?php echo lang('list_sale'); ?></h2>
                        <p class="modern-table-subtitle">View and manage your sales records</p>
                    </div>
                </div>
                <div class="card-body table-responsive profile_min_height">
                    <input type="hidden" class="datatable_name" data-title="@lang('index.ticket')" data-id_name="datatable">
                    <table id="datatable" class="table table-responsive">
                        <thead>
                            <tr>
                                <th class="w-5"><?php echo lang('sn'); ?></th>
                                <th class="w-15"><?php echo lang('sale_no'); ?></th>
                                <th class="w-19"><?php echo lang('customer'); ?></th>
                                <th class="w-10 text-center"><?php echo lang('items'); ?></th>
                                <th class="w-18 text-center"><?php echo lang('total_payable'); ?></th>
                                <th class="w-18 text-center"><?php echo lang('paid_amount'); ?></th>
                                <th class="w-15"><?php echo lang('sale_date'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($sales as $key => $sale): ?>
                            <tr>
                                <td><?php echo $key +1 ?></td>
                                <td><?php echo escape_output($sale->sale_no) ?></td>
                                <td><?php echo escape_output($sale->customer_name) ?><?php echo escape_output($sale->customer_phone) ? '(' . $sale->customer_name . ')' : '' ?></td>
                                <td class="text-center"><?php echo escape_output($sale->total_items) ?></td>
                                <td class="text-center"><?php echo getAmtCustom($sale->total_payable) ?></td>
                                <td class="text-center"><?php echo getAmtCustom($sale->paid_amount) ?></td>
                                <td><?php echo dateFormatWithTime($sale->date_time) ?></td>
                            </tr>
                            <?php endforeach;?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>


<?php $this->view('updater/reuseJs')?>


