<style>
/* Soft Dark Neumorphism (Morphism) UI Enhancements - Updated (copied from roles/users/items/rack list) */
body, .main-content-wrapper {
    background: #23272f !important;
    color: #fff !important;
}
.main-content-wrapper {
    min-height: 100vh;
    padding: 32px 0 0 0;
    background: #23272f !important;
}
.box-wrapper {
    background: #23272f;
    border-radius: 6px;
    box-shadow: 8px 8px 24px #1a1d22, -8px -8px 24px #2c313a;
    padding: 32px 24px 24px 24px;
    margin-top: 24px;
    color: #fff;
}
.table-box {
    background: #23272f;
    border-radius: 6px;
    box-shadow: 4px 4px 16px #1a1d22, -4px -4px 16px #2c313a;
    padding: 16px;
    color: #fff;
}
table.table {
    background: #23272f;
    color: #fff;
    border-radius: 6px;
    overflow: hidden;
    box-shadow: 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
}
table.table thead {
    background: linear-gradient(90deg, rgb(77,62,82) 0%, #232b33 100%);
    border-top-left-radius: 6px;
    border-top-right-radius: 6px;
}
table.table thead th {
    color: #fff !important;
    background: transparent !important;
    font-weight: 600;
    font-size: 1.05rem;
    border: none;
}
table.table tbody tr {
    background: #23272f;
    transition: background 0.2s;
    color: #fff;
}
table.table tbody tr:nth-of-type(odd) {
    background-color: #23272f;
}
table.table tbody tr:nth-of-type(even) {
    background-color: #232b33;
}
table.table tbody tr:hover {
    background: #31353f;
}
table.table td, table.table th {
    border: none !important;
    color: #fff;
}
.btn_group_wrap a.btn {
    border-radius: 6px;
    background: #23272f;
    color: #fff;
    box-shadow: 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
    border: none;
    transition: background 0.2s, color 0.2s, box-shadow 0.2s;
    margin-right: 6px;
    padding: 6px 14px;
    font-size: 1rem;
}
.btn_group_wrap a.btn:hover {
    background: #31353f;
    color: #fff;
    box-shadow: 0 0 0 2px #4F46E5, 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
}
.btn_list .new-btn {
    border-radius: 6px;
    background: linear-gradient(145deg, #23272f 60%, #2c313a 100%);
    color: #fff;
    box-shadow: 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
    border: none;
    padding: 8px 20px;
    font-size: 1.08rem;
    font-weight: 500;
    transition: background 0.2s, color 0.2s, box-shadow 0.2s;
}
.btn_list .new-btn:hover {
    background: #4F46E5;
    color: #fff;
    box-shadow: 0 0 0 2px #4F46E5, 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
}
.content-header {
    background: linear-gradient(90deg, #31353f 0%, #232b33 100%);
    border-radius: 6px;
    box-shadow: 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
    padding: 24px 24px 16px 24px;
    margin-bottom: 24px;
}
.content-header h3.top-left-header {
    color: #fff;
    text-shadow: 1px 1px 4px #1a1d22;
    background: linear-gradient(90deg, #4F46E5 0%, #232b33 100%);
    border-radius: 6px;
    padding: 8px 24px;
    display: inline-block;
    box-shadow: 1px 1px 6px #1a1d22;
}
.alert-wrapper .alert {
    background: #2c313a;
    color: #fff;
    border-radius: 6px;
    border: none;
    box-shadow: 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
}
.exportDropdown .toggleBtn {
    background: #fe5500 !important;
    color: #fff !important;
    border: 2px double #fff;
    border-radius: 4px;
    padding: 10px 28px 10px 18px;
    font-size: 1.08rem;
    font-weight: 600;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    position: relative;
    box-shadow: 2px 2px 8px #1a1d22, -2px -2px 8px #2c313a;
    transition: background 0.2s, color 0.2s;
    overflow: hidden;
}
.exportDropdown .toggleBtn span, .exportDropdown .toggleBtn svg {
    color: #fff !important;
    fill: #fff !important;
}
.exportDropdown .toggleBtn svg.feather-share {
    margin-right: 8px;
    color: #fff;
}
.exportDropdown .toggleBtn:hover {
    background: #232323;
    color: #fff;
}
.exportDropdown .toggleBtn::after {
    content: '';
    display: block;
    position: absolute;
    left: -40%;
    top: 0;
    width: 60%;
    height: 100%;
    background: linear-gradient(120deg, rgba(255,255,255,0.18) 0%, rgba(255,255,255,0.04) 100%);
    transform: skewX(-20deg) translateX(-100%);
    transition: transform 0.5s cubic-bezier(.4,2,.6,1);
    pointer-events: none;
}
.exportDropdown .toggleBtn:hover::after {
    transform: skewX(-20deg) translateX(120%);
}
</style>

<div class="main-content-wrapper">
<?php
if ($this->session->flashdata('exception')) {
    echo '<section class="alert-wrapper"><div class="alert alert-success alert-dismissible fade show"> 
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-hidden="true"></button>
    <div class="alert-body"><i class="icon fa fa-check me-2"></i>';
    echo escape_output($this->session->flashdata('exception'));unset($_SESSION['exception']);
    echo '</div></div></section>';
}
?>

    <section class="content-header">
        <div class="row justify-content-between">
            <div class="col-6 p-0">
                <h3 class="top-left-header"><?php echo lang('list_unit'); ?> </h3>
                <input type="hidden" class="datatable_name" data-title="<?php echo lang('list_unit'); ?>" data-id_name="datatable">
                <div class="btn_list m-right d-flex">
                    <a class="new-btn me-1" href="<?php echo base_url() ?>Unit/addEditUnit">
                    <iconify-icon icon="solar:add-circle-broken" width="22"></iconify-icon> <?php echo lang('add_unit'); ?>
                    </a>
                </div>
            </div>
            <?php $this->view('updater/breadcrumb', ['firstSection'=> lang('unit'), 'secondSection'=> lang('list_unit')])?>
        </div>
    </section>



    <div class="box-wrapper">
        <div class="table-box">
            <div class="table-responsive">
                <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th class="w-5"><?php echo lang('sn'); ?></th>
                            <th class="w-30"><?php echo lang('unit_name'); ?></th>
                            <th class="w-40"><?php echo lang('description'); ?></th>
                            <th class="w-10"><?php echo lang('added_by'); ?></th>
                            <th class="w-10"><?php echo lang('added_date'); ?></th>
                            <th class="w-5"><?php echo lang('actions'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                                if ($Units && !empty($Units)) {
                                    $i = count($Units);
                                }
                                foreach ($Units as $unit) {
                                    ?>
                        <tr>
                            <td class="text-center"><?php echo $i--; ?></td>
                            <td><?php echo escape_output($unit->unit_name); ?></td>
                            <td><?php echo escape_output($unit->description); ?></td>
                            <td><?php echo escape_output($unit->added_by); ?></td>
                            <td><?php echo date($this->session->userdata('date_format'), strtotime($unit->added_date != '' ? $unit->added_date : '')); ?></td>
                            <td>
                                <div class="btn_group_wrap">
                                    <a class="btn btn-warning" href="<?php echo base_url() ?>Unit/addEditUnit/<?php echo $this->custom->encrypt_decrypt($unit->id, 'encrypt'); ?>" data-bs-toggle="tooltip" data-bs-placement="top"
                                    data-bs-original-title="<?php echo lang('edit'); ?>">
                                        <i class="far fa-edit"></i>
                                    </a>
                                    <a class="delete btn btn-danger" href="<?php echo base_url() ?>Unit/deleteUnit/<?php echo $this->custom->encrypt_decrypt($unit->id, 'encrypt'); ?>" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="<?php echo lang('delete'); ?>">
                                        <i class="fa-regular fa-trash-can"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php
                            }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $this->view('updater/reuseJs'); ?>